﻿
' TODO: 将搜索结果页连接至应用程序内的搜索。
'“搜索结果页”项模板在 http://go.microsoft.com/fwlink/?LinkId=234240 上有介绍

''' <summary>
''' 此页显示全局搜索定向到此应用程序时的搜索结果。
''' </summary>
Public NotInheritable Class $safeitemname$
    Inherits Page

    Private _navigationHelper As Common.NavigationHelper
    Public ReadOnly Property NavigationHelper() As Common.NavigationHelper
        Get
            Return Me._navigationHelper
        End Get
    End Property

    ''' <summary>
    ''' 可将其更改为强类型视图模型。
    ''' </summary>
    Public ReadOnly Property DefaultViewModel As Common.ObservableDictionary
        Get
            Return Me._defaultViewModel
        End Get
    End Property
    Private _defaultViewModel As New Common.ObservableDictionary()


    Public Sub New()
        Me.InitializeComponent()
        Me._navigationHelper = New Common.NavigationHelper(Me)
        AddHandler Me._navigationHelper.LoadState, AddressOf NavigationHelper_LoadState
    End Sub

    ''' <summary>
    ''' 使用在导航过程中传递的内容填充页。  在从以前的会话
    ''' 重新创建页时，也会提供任何已保存状态。
    ''' </summary>
    ''' <param name="sender">
    ''' 事件的来源; 通常为 <see cref="NavigationHelper"/>
    ''' </param>
    ''' <param name="e">事件数据，其中既提供在最初请求此页时传递给
    ''' <see cref="Frame.Navigate"/> 的导航参数，又提供
    ''' 此页在以前会话期间保留的状态的
    ''' 字典。 首次访问页面时，该状态将为 null。</param>
    Private Sub NavigationHelper_LoadState(sender As Object, e As Common.LoadStateEventArgs)
        Dim queryText As String = TryCast(e.NavigationParameter, [String])

        ' TODO:  特定于应用程序的搜索逻辑。  搜索进程负责
        '       创建用户可选的结果类别列表: 
        '
        '       filterList.Add(new Filter("<filter name>", <result count>));
        '
        '       仅第一个筛选器(通常为“全部”)应将 true 作为第三个参数传入
        '       以便以活动状态开始。  活动筛选器的结果在
        '       下面的 Filter_SelectionChanged 中提供。

        Dim filterList As New List(Of Filter)()
        filterList.Add(New Filter("All", 0, True))

        ' 通过视图模型沟通结果
        Me.DefaultViewModel("QueryText") = ChrW(&H201C) + queryText + ChrW(&H201D)
        Me.DefaultViewModel("Filters") = filterList
        Me.DefaultViewModel("ShowFilters") = filterList.Count > 1
    End Sub

    ''' <summary>
    ''' 在未对齐的情况下使用 RadioButton 选定筛选器时进行调用。
    ''' </summary>
    ''' <param name="sender">选定的 RadioButton 实例。</param>
    ''' <param name="e">描述如何选定 RadioButton 的事件数据。</param>
    Private Sub Filter_Checked(sender As Object, e As RoutedEventArgs)
        Dim filter As Object = TryCast(sender, FrameworkElement).DataContext

        ' 将更改镜像到 CollectionViewSource。
        If filtersViewSource.View IsNot Nothing Then
            filtersViewSource.View.MoveCurrentTo(filter)
        End If

        ' 确定选定的筛选器
        Dim selectedFilter As Filter = TryCast(filter, Filter)
        If selectedFilter IsNot Nothing Then
            ' 将结果镜像到相应的筛选器对象中，以允许
            ' 在未对齐以反映更改时使用的 RadioButton 表示形式
            selectedFilter.Active = True

            ' TODO:  通过设置 Me.DefaultViewModel["Results"] 对活动筛选器中的更改作出响应
            '       具有可绑定的 Image、Title、Subtitle 和 Description 属性的项的集合

            ' 确保找到结果
            Dim results As Object = Nothing

            If Me.DefaultViewModel.TryGetValue("Results", results) Then
                Dim ResultsCollection As ICollection = TryCast(results, ICollection)
                If ResultsCollection IsNot Nothing AndAlso ResultsCollection.Count <> 0 Then
                    VisualStateManager.GoToState(Me, "ResultsFound", True)
                    Return
                End If
            End If
        End If
        ' 无搜索结果时显示信息性文本。
        VisualStateManager.GoToState(Me, "NoResultsFound", True)
    End Sub

#Region "NavigationHelper 注册"

    ''' 此部分中提供的方法只是用于使
    ''' NavigationHelper 可响应页面的导航方法。
    ''' 
    ''' 应将页面特有的逻辑放入用于
    ''' <see cref="Common.NavigationHelper.LoadState"/>
    ''' 和 <see cref="Common.NavigationHelper.SaveState"/> 的事件处理程序中。
    ''' 除了在会话期间保留的页面状态之外
    ''' LoadState 方法中还提供导航参数。

    Protected Overrides Sub OnNavigatedTo(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedTo(e)
    End Sub

    Protected Overrides Sub OnNavigatedFrom(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedFrom(e)
    End Sub

#End Region

    ''' <summary>
    ''' 描述可用于查看搜索结果的筛选器之一的视图模型。
    ''' </summary>
    Private NotInheritable Class Filter
        Implements INotifyPropertyChanged
        Private _name As String
        Private _count As Integer
        Private _active As Boolean

        Public Sub New(name As String, count As Integer, Optional active As Boolean = False)
            Me.Name = name
            Me.Count = count
            Me.Active = active
        End Sub

        Public Overrides Function ToString() As String
            Return Description
        End Function

        Public Property Name As String
            Get
                Return _name
            End Get
            Set(value As String)
                If Me.SetProperty(_name, value) Then Me.OnPropertyChanged("Description")
            End Set
        End Property

        Public Property Count As Integer
            Get
                Return _count
            End Get
            Set(value As Integer)
                If Me.SetProperty(_count, value) Then Me.OnPropertyChanged("Description")
            End Set
        End Property

        Public Property Active As Boolean
            Get
                Return _active
            End Get
            Set(value As Boolean)
                Me.SetProperty(_active, value)
            End Set
        End Property

        Public ReadOnly Property Description As String
            Get
                Return String.Format("{0} ({1})", _name, _count)
            End Get
        End Property

        ''' <summary>
        ''' 针对属性更改通知的多播事件。
        ''' </summary>
        Public Event PropertyChanged As PropertyChangedEventHandler Implements INotifyPropertyChanged.PropertyChanged

        ''' <summary>
        ''' 检查属性是否已与所需值匹配。    仅当需要时才设置
        ''' 该属性并通知侦听器。
        ''' </summary>
        ''' <typeparam name="T">属性的类型。</typeparam>
        ''' <param name="storage">对具有 getter 和 setter 的属性的引用。</param>
        ''' <param name="value">属性的所需值。</param>
        ''' <param name="propertyName">用于通知侦听器的属性的名称。    此
        ''' 值是可选的，可以在从支持 CallerMemberName 的编译器调用时
        ''' 自动提供。</param>
        ''' <returns>如果更改了值，则为 true，如果现有值与所需值匹配，
        ''' 则为 false。</returns>
        Private Function SetProperty(Of T)(ByRef storage As T, value As T, <CallerMemberName> Optional propertyName As [String] = Nothing) As Boolean
            If Object.Equals(storage, value) Then
                Return False
            End If

            storage = value
            Me.OnPropertyChanged(propertyName)
            Return True
        End Function

        ''' <summary>
        ''' 向侦听器通知已更改了某个属性值。
        ''' </summary>
        ''' <param name="propertyName">用于通知侦听器的属性的名称。    此
        ''' 值是可选的，可以在从支持
        ''' <see cref="CallerMemberNameAttribute"/> 的编译器调用时自动提供。</param>
        Private Sub OnPropertyChanged(<CallerMemberName> Optional propertyName As String = Nothing)
            RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(propertyName))
        End Sub

    End Class
End Class
